<?php
// admin/auth.php

// 1. Iniciar sesión (si no está iniciada ya)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 2. BLOQUEAR CACHÉ (Esto soluciona lo del botón "Atrás")
// Le dice al navegador: "Nunca guardes esta página en memoria, pídela siempre al servidor".
header("Cache-Control: no-cache, no-store, must-revalidate"); // HTTP 1.1.
header("Pragma: no-cache"); // HTTP 1.0.
header("Expires: 0"); // Proxies.

// 3. VERIFICAR SI ESTÁ LOGUEADO
// Cambia 'user_id' por la variable que uses en tu login (ej: 'admin_id', 'usuario', etc.)
if (!isset($_SESSION['user_id'])) {
    // Si no hay sesión, mandar al login
    header("Location: login.php");
    exit();
}
?>